/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.sound;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.Listener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundEngineExecutor;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.ChannelHandleAccessor;
import org.figuramc.figura.ducks.SoundEngineAccessor;
import org.figuramc.figura.ducks.SubtitleOverlayAccessor;
import org.figuramc.figura.lua.api.sound.LuaSound;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements SoundEngineAccessor {
    @Shadow
    @Final
    private Library library;
    @Shadow
    @Final
    private SoundEngineExecutor executor;
    @Shadow
    @Final
    private SoundBufferLibrary soundBuffers;
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Listener listener;
    @Shadow
    @Final
    private List<SoundEventListener> listeners;
    @Unique
    private ChannelAccess figuraChannel;
    @Unique
    private final List<LuaSound> figuraHandlers = Collections.synchronizedList(new ArrayList());

    @Shadow
    protected abstract float getVolume(@Nullable SoundSource var1);

    @Shadow
    public abstract void addEventListener(SoundEventListener var1);

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/client/sounds/SoundManager;Lnet/minecraft/client/Options;Lnet/minecraft/server/packs/resources/ResourceProvider;)V"})
    private void soundEngineInit(SoundManager soundManager, Options options, ResourceProvider resourceProvider, CallbackInfo ci) {
        this.figuraChannel = new ChannelAccess(this.library, (Executor)this.executor);
    }

    @Inject(at={@At(value="RETURN")}, method={"tick(Z)V"})
    private void tick(boolean bl, CallbackInfo ci) {
        this.figuraChannel.scheduleTick();
    }

    @Inject(at={@At(value="RETURN")}, method={"tickNonPaused()V"})
    private void tickNonPaused(CallbackInfo ci) {
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            ChannelAccess.ChannelHandle handle = sound.getHandle();
            if (handle == null) {
                iterator.remove();
                continue;
            }
            if (this.getVolume(SoundSource.PLAYERS) <= 0.0f) {
                handle.execute(Channel::stop);
                iterator.remove();
                continue;
            }
            if (!handle.isStopped()) continue;
            iterator.remove();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stopAll()V"})
    private void stopAll(CallbackInfo ci) {
        this.figura$stopAllSounds();
    }

    @Inject(at={@At(value="RETURN")}, method={"pause()V"})
    private void pause(CallbackInfo ci) {
        if (this.loaded) {
            this.figuraChannel.executeOnChannels(stream -> stream.forEach(Channel::pause));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"resume()V"})
    private void resume(CallbackInfo ci) {
        if (this.loaded) {
            this.figuraChannel.executeOnChannels(stream -> stream.forEach(Channel::unpause));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"updateCategoryVolume(Lnet/minecraft/sounds/SoundSource;F)V"})
    private void updateCategoryVolume(SoundSource category, float volume, CallbackInfo ci) {
        if (!this.loaded || category != SoundSource.PLAYERS) {
            return;
        }
        for (LuaSound sound : this.figuraHandlers) {
            sound.volume(sound.getVolume());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stop(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;)V"})
    private void stop(ResourceLocation id, SoundSource category, CallbackInfo ci) {
        if (category == SoundSource.PLAYERS) {
            this.figura$stopAllSounds();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")}, method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, cancellable=true)
    public void play(SoundInstance sound, CallbackInfo c) {
        float g = Math.max(sound.getVolume(), 1.0f) * (float)sound.getSound().getAttenuationDistance();
        Vec3 pos = new Vec3(sound.getX(), sound.getY(), sound.getZ());
        if (sound.isRelative() || sound.getAttenuation() == SoundInstance.Attenuation.NONE || this.listener.getTransform().position().distanceToSqr(pos) < (double)(g * g)) {
            AvatarManager.executeAll("playSoundEvent", avatar -> {
                boolean cancel = avatar.playSoundEvent(sound.getLocation().toString(), FiguraVec3.fromVec3(pos), sound.getVolume(), sound.getPitch(), sound.isLooping(), sound.getSource().name(), sound.getSound().getLocation().toString());
                if (avatar.permissions.get(Permissions.CANCEL_SOUNDS) >= 1) {
                    avatar.noPermissions.remove(Permissions.CANCEL_SOUNDS);
                    if (cancel) {
                        c.cancel();
                    }
                } else if (cancel) {
                    avatar.noPermissions.add(Permissions.CANCEL_SOUNDS);
                }
            });
        }
    }

    @Override
    @Intrinsic
    public void figura$addSound(LuaSound sound) {
        this.figuraHandlers.add(sound);
        for (SoundEventListener listener : this.listeners) {
            if (!(listener instanceof SubtitleOverlay)) continue;
            SubtitleOverlay overlay = (SubtitleOverlay)listener;
            float g = sound.getVolume() * sound.calculateVolume() * sound.getAttenuation() * 16.0f;
            ((SubtitleOverlayAccessor)overlay).figura$PlaySound(sound, g);
        }
    }

    @Override
    @Intrinsic
    public void figura$stopSound(UUID owner, String name) {
        if (!this.loaded) {
            return;
        }
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (accessor == null || owner != null && (!accessor.getOwner().equals(owner) || name != null && !accessor.getName().equals(name))) continue;
            sound.stop();
            iterator.remove();
        }
    }

    @Override
    @Intrinsic
    public void figura$stopAllSounds() {
        if (this.loaded) {
            for (LuaSound sound : this.figuraHandlers) {
                sound.stop();
            }
            this.figuraHandlers.clear();
            this.figuraChannel.clear();
        }
    }

    @Override
    @Intrinsic
    public ChannelAccess.ChannelHandle figura$createHandle(UUID owner, String name, Library.Pool pool) {
        return (ChannelAccess.ChannelHandle)((CompletableFuture)this.figuraChannel.createHandle(pool).thenApply(channelHandle -> {
            if (channelHandle != null) {
                ((ChannelHandleAccessor)channelHandle).setOwner(owner);
                ((ChannelHandleAccessor)channelHandle).setName(name);
            }
            return channelHandle;
        })).join();
    }

    @Override
    @Intrinsic
    public float figura$getVolume(SoundSource category) {
        return this.getVolume(category);
    }

    @Override
    @Intrinsic
    public SoundBufferLibrary figura$getSoundBuffers() {
        return this.soundBuffers;
    }

    @Override
    @Intrinsic
    public boolean figura$isPlaying(UUID owner) {
        if (!this.loaded) {
            return false;
        }
        for (LuaSound sound : List.copyOf(this.figuraHandlers)) {
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (!sound.isPlaying() || accessor == null || !accessor.getOwner().equals(owner)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean figura$isEngineActive() {
        return this.loaded;
    }
}

